const React = require("react");
function ArrowTurnDownRightIcon({
  title,
  titleId,
  ...props
}, svgRef) {
  return /*#__PURE__*/React.createElement("svg", Object.assign({
    xmlns: "http://www.w3.org/2000/svg",
    fill: "none",
    viewBox: "0 0 24 24",
    strokeWidth: 1.5,
    stroke: "currentColor",
    "aria-hidden": "true",
    "data-slot": "icon",
    ref: svgRef,
    "aria-labelledby": titleId
  }, props), title ? /*#__PURE__*/React.createElement("title", {
    id: titleId
  }, title) : null, /*#__PURE__*/React.createElement("path", {
    strokeLinecap: "round",
    strokeLinejoin: "round",
    d: "m16.49 12 3.75 3.75m0 0-3.75 3.75m3.75-3.75H3.74V4.499"
  }));
}
const ForwardRef = /*#__PURE__*/ React.forwardRef(ArrowTurnDownRightIcon);
module.exports = ForwardRef;